% Finaquant Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 6August2012
% TITLE: Efficient risk frontier
%
% Deriving minimum or maximum expected risk points (i.e. standard deviation) 
% and corresponding asset weights for a given expected returns with 
% constrained optimization function fmincon()
%
% Central download page:
% http://finaquant.com/download
function PortfolioVariance = PortfolioRisk(CovMatrix, AssetWeights)
% input parameters:
% CovMatrix: Covariance matrix of risky assets in portfolio; NxM matrix for M assets
% AssetWeights: Mx1 matrix (i.e. vector) with weight coefficients of each risky asset
%   with values between 0 and 1

% check matrix sizes
if isempty(CovMatrix) 
    error ('CovMatrix is empty!');
end
[rowsC, colsC] = size(CovMatrix);
if rowsC ~= colsC
    error ('CovMatrix must be a square matrix!');
end
[rowsW, colsW] = size(AssetWeights);
if colsW ~= 1
    error ('AssetWeights must be a Mx1 vector!');
end
if rowsW ~= rowsC
    error ('Length of vector AssetWeights must be equal to the row/column size of CovMatrix!');
end  

% size checks done, continue ...
PortfolioVariance = AssetWeights' * CovMatrix * AssetWeights;